﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;
using System.Text;
using System.Threading.Tasks;

namespace VA.PPMS.IWS.Common
{
    public class DasOutcome
    {
        public const string AllOk = "allok";
        public const string Exception = "exception";

        private const string Delimiter = "++";

        [DataMember]
        public string Id { get; set; }

        [DataMember]
        public string Severity { get; set; }

        [DataMember]
        public string Code { get; set; }

        [DataMember]
        public string Details { get; set; }

        public bool IsValid => !string.IsNullOrEmpty(Id);

        public bool IsSuccessful => Id == AllOk;

        public DasOutcome()
        { }

        public DasOutcome(string message)
        {
            ParseMessage(message);
        }

        public override string ToString()
        {
            return $"{Id}{Delimiter}{Severity}{Delimiter}{Code}{Delimiter}{Details}";
        }

        private void ParseMessage(string message)
        {
            Reset();

            var items = message.Split(new[] { Delimiter }, StringSplitOptions.None);

            if (items.Length == 4)
            {
                Id = items[0];
                Severity = items[1];
                Code = items[2];
                Details = items[3];
            }
        }

        private void Reset()
        {
            Id = null;
            Severity = null;
            Code = null;
            Details = null;
        }
    }
}
